/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aetherfabric.registries;

import com.aetherteam.aetherfabric.common.conditions.WithConditions;
import com.aetherteam.aetherfabric.pond.FullDataMapAccess;
import com.aetherteam.aetherfabric.registries.RegistryManager;
import com.aetherteam.aetherfabric.registries.datamaps.AdvancedDataMapType;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapEntry;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapFile;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapType;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapValueMerger;
import com.aetherteam.aetherfabric.registries.datamaps.DataMapsUpdatedEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import org.slf4j.Logger;

public class DataMapLoader
implements class_3302,
IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PATH = "data_maps";
    public static final class_2960 ID = class_2960.method_60655((String)"aether_fabric", (String)"data_maps");
    private static Map<class_5321<? extends class_2378<?>>, LoadResult<?>> results = null;
    private final class_7225.class_7874 registryAccess;

    public DataMapLoader(class_7225.class_7874 registryAccess) {
        this.registryAccess = registryAccess;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)this.load(resourceManager, backgroundExecutor, preparationsProfiler).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(values -> {
            results = values;
        }, gameExecutor);
    }

    public static void apply(class_5455 registryAccess) {
        if (results == null) {
            return;
        }
        results.forEach((key, result) -> DataMapLoader.apply((class_2370)registryAccess.method_30530(key), result, registryAccess));
        results = null;
    }

    private static <T> void apply(class_2370<T> registry, LoadResult<T> result, class_5455 registryAccess) {
        ((FullDataMapAccess)registry).setDataMaps(dataMaps -> result.results().forEach((key, entries) -> dataMaps.put(key, DataMapLoader.buildDataMap(registry, key, entries))));
        ((DataMapsUpdatedEvent.CallBack)DataMapsUpdatedEvent.EVENT.invoker()).onUpdate(new DataMapsUpdatedEvent(registryAccess, (class_2378<?>)registry, DataMapsUpdatedEvent.UpdateCause.SERVER_RELOAD));
    }

    private static <T, R> Map<class_5321<R>, T> buildDataMap(class_2378<R> registry, DataMapType<R, T> attachment, List<DataMapFile<T, R>> entries) {
        DataMapValueMerger dataMapValueMerger;
        record WithSource<T, R>(T attachment, Either<class_6862<R>, class_5321<R>> source) {
        }
        IdentityHashMap<class_5321, WithSource> result = new IdentityHashMap<class_5321, WithSource>();
        BiConsumer<Either, Consumer> valueResolver = (key, cons) -> key.ifLeft(tag -> registry.method_40286(tag).forEach(cons)).ifRight(k -> cons.accept(registry.method_40290(k)));
        if (attachment instanceof AdvancedDataMapType) {
            AdvancedDataMapType adv = (AdvancedDataMapType)attachment;
            dataMapValueMerger = adv.merger();
        } else {
            dataMapValueMerger = DataMapValueMerger.defaultMerger();
        }
        DataMapValueMerger merger = dataMapValueMerger;
        entries.forEach(entry -> {
            if (entry.replace()) {
                result.clear();
            }
            entry.values().forEach((tKey, value) -> {
                if (value.isEmpty()) {
                    return;
                }
                valueResolver.accept((Either)tKey, holder -> {
                    DataMapEntry newValue = (DataMapEntry)((WithConditions)value.get()).carrier();
                    class_5321 key = (class_5321)holder.method_40230().orElseThrow();
                    WithSource oldValue = (WithSource)result.get(key);
                    if (oldValue == null || newValue.replace()) {
                        result.put(key, new WithSource(newValue.value(), tKey));
                    } else {
                        result.put(key, new WithSource(merger.merge(registry, oldValue.source(), oldValue.attachment(), tKey, newValue.value()), tKey));
                    }
                });
            });
            entry.removals().forEach(trRemoval -> valueResolver.accept(trRemoval.key(), holder -> {
                if (trRemoval.remover().isPresent()) {
                    class_5321 key = (class_5321)holder.method_40230().orElseThrow();
                    WithSource oldValue = (WithSource)result.get(key);
                    if (oldValue != null) {
                        Optional newValue = trRemoval.remover().get().remove(oldValue.attachment(), registry, oldValue.source(), holder.comp_349());
                        if (newValue.isEmpty()) {
                            result.remove(key);
                        } else {
                            result.put(key, new WithSource(newValue.get(), oldValue.source()));
                        }
                    }
                } else {
                    result.remove(holder.method_40230().orElseThrow());
                }
            }));
        });
        IdentityHashMap newMap = new IdentityHashMap();
        result.forEach((key, val) -> newMap.put(key, val.attachment()));
        return newMap;
    }

    private CompletableFuture<Map<class_5321<? extends class_2378<?>>, LoadResult<?>>> load(class_3300 manager, Executor executor, class_3695 profiler) {
        return CompletableFuture.supplyAsync(() -> DataMapLoader.load(manager, profiler, this.registryAccess), executor);
    }

    private static Map<class_5321<? extends class_2378<?>>, LoadResult<?>> load(class_3300 manager, class_3695 profiler, class_7225.class_7874 access) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)access);
        HashMap values = new HashMap();
        access.method_55282().forEach(registryKey -> {
            profiler.method_15396("registry_data_maps/" + String.valueOf(registryKey.method_29177()) + "/locating");
            class_7654 fileToId = class_7654.method_45114((String)("data_maps/" + DataMapLoader.getFolderLocation(registryKey.method_29177())));
            for (Map.Entry entry : fileToId.method_45116(manager).entrySet()) {
                class_2960 key = (class_2960)entry.getKey();
                class_2960 attachmentId = fileToId.method_45115(key);
                DataMapType attachment = RegistryManager.getDataMap(registryKey, attachmentId);
                if (attachment == null) {
                    LOGGER.warn("Found data map file for non-existent data map type '{}' on registry '{}'.", (Object)attachmentId, (Object)registryKey.method_29177());
                    continue;
                }
                profiler.method_15405("registry_data_maps/" + String.valueOf(registryKey.method_29177()) + "/" + String.valueOf(attachmentId) + "/loading");
                values.computeIfAbsent(registryKey, (Function<class_5321, LoadResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$14(net.minecraft.class_5321 ), (Lnet/minecraft/class_5321;)Lcom/aetherteam/aetherfabric/registries/DataMapLoader$LoadResult;)()).results.put(attachment, DataMapLoader.readData((class_6903<JsonElement>)ops, attachment, registryKey, (List)entry.getValue()));
            }
            profiler.method_15407();
        });
        return values;
    }

    public static String getFolderLocation(class_2960 registryId) {
        return (String)(registryId.method_12836().equals("minecraft") ? "" : registryId.method_12836() + "/") + registryId.method_12832();
    }

    private static <A, T> List<DataMapFile<A, T>> readData(class_6903<JsonElement> ops, DataMapType<T, A> attachmentType, class_5321<class_2378<T>> registryKey, List<class_3298> resources) {
        Codec<DataMapFile<A, T>> codec = DataMapFile.codec(registryKey, attachmentType);
        LinkedList<DataMapFile<A, T>> entries = new LinkedList<DataMapFile<A, T>>();
        for (class_3298 resource : resources) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                    entries.add((DataMapFile)((Pair)codec.decode(ops, (Object)jsonelement).getOrThrow()).getFirst());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Could not read data map of type {} for registry {}", new Object[]{attachmentType.id(), registryKey, exception});
            }
        }
        return entries;
    }

    private static /* synthetic */ LoadResult lambda$load$14(class_5321 k) {
        return new LoadResult(new HashMap());
    }

    private record LoadResult<T>(Map<DataMapType<T, ?>, List<DataMapFile<?, T>>> results) {
    }
}

